// import particles_config from './particles.config.json' assert { type: 'json' };

export async function typing(elements, key_time = 200) {
  function type(element, last) {
    return new Promise(function (resolve, reject) {
      let $this = $(element);
      let text = $this.text();

      if (typeof $this.attr('data-text') == 'undefined') {
        $this.attr('data-text', text);
      } else {
        text = $this.attr('data-text');
      }
  
      $this.addClass('active');
      $this.text('');          
      
      let chars = text.split('');
      let count = 0;
  
      let interval = setInterval(() => {
        if (count < chars.length) {
          $this.find('.cursor').remove();
          $this.html($this.text() + chars[count] + '<div class="cursor">_</div>');
          count++;
        } else {
          clearInterval(interval);
          if (last === false) $this.find('.cursor').remove();
          resolve(true);
        }
      }, key_time);
    });
  }

  return new Promise(async function (resolve, reject) {
    elements = $(elements);
    let count = 0;
    for (let el of elements) {
      let last = count == (elements.length - 1) ? true : false;
      await type($(el), last);
      count++
    }

    resolve();
  })
}
